function [I1,I2,A1o,A2o] = removeOutsideBoxes(I1,I2,A1,A2)
%REMOVEOUTSIDEBOXES Summary of this function goes here
%   Detailed explanation goes here

%Remove outside image boxes
A1o = [];
for r = 1:size(A1,1)
    w = A1(r,4);
    h = A1(r,5);
    top = (A1(r,3) - h/2);
    bottom = (A1(r,3) + h/2);
    left = (A1(r,2) - w/2);
    right = (A1(r,2) + w/2);
    
    if(w<0 || h<0 || w>1 || h>1) %Bad dimensions
        continue;
    end
    if(top<0 || bottom>1 || left<0 || right>1) %Corner outside image (should have been truncated)
        disp("Removing annot with corner outside image");
        continue;
    end
    if(top>1 || bottom<0 || left>1 || right<0) %This should not occur
        disp("Annotation transposition error in removeOutsideBoxes!");
        continue;
    end

    A1o(end+1,:) = A1(r,:);

end

A1 = A1o;
A1o = [];
%Remove boxes with > 50% white
[rows, cols, ~] = size(I1);
for r = 1:size(A1,1)
    w = A1(r,4);
    h = A1(r,5);
    top = (A1(r,3) - h/2);
    bottom = (A1(r,3) + h/2);
    left = (A1(r,2) - w/2);
    right = (A1(r,2) + w/2);

    top = round(top*rows);
    bottom = round(bottom*rows);
    left = round(left*cols);
    right = round(right*cols);
    
    boxPix = I1(top:bottom,left:right,:);
    mask = bitor((boxPix>250),(boxPix<5));
    mask = mask(:,:,1) .* mask(:,:,2) .* mask(:,:,3);
    if(sum(mask(:)) > 0.4*size(boxPix,1)*size(boxPix,2))
        continue;
    end

    A1o(end+1,:) = A1(r,:);
end

%Remove outside image boxes
A2o = [];
for r = 1:size(A2,1)
    w = A2(r,4);
    h = A2(r,5);
    top = (A2(r,3) - h/2);
    bottom = (A2(r,3) + h/2);
    left = (A2(r,2) - w/2);
    right = (A2(r,2) + w/2);

    if(w<0 || h<0 || w>1 || h>1) %Bad dimensions
        continue;
    end
    if(top<0 || bottom>1 || left<0 || right>1) %Corner outside image (should have been truncated)
        disp("Removing annot with corner outside image");
        continue;
    end
    if(top>1 || bottom<0 || left>1 || right<0) %This should not occur
        disp("Annotation transposition error in removeOutsideBoxes!");
        continue;
    end

    A2o(end+1,:) = A2(r,:);

end

A2 = A2o;
A2o = [];

%Remove boxes with > 50% white
[rows, cols, ~] = size(I2);
for r = 1:size(A2,1)
    w = A2(r,4);
    h = A2(r,5);
    top = (A2(r,3) - h/2);
    bottom = (A2(r,3) + h/2);
    left = (A2(r,2) - w/2);
    right = (A2(r,2) + w/2);

    top = round(top*rows);
    bottom = round(bottom*rows);
    left = round(left*cols);
    right = round(right*cols);
    
    boxPix = I2(top:bottom,left:right,:);
    mask = bitor((boxPix>250),(boxPix<5));
    mask = mask(:,:,1) .* mask(:,:,2) .* mask(:,:,3);
    if(sum(mask(:)) > 0.4*size(boxPix,1)*size(boxPix,2))
        continue;
    end

    A2o(end+1,:) = A2(r,:);
end

end

